* Replication files for
* "Capital Reallocation and the Cyclicality of Aggregate Productivity" by Russ Cooper & Immo Schott
* Prepared: May 2023

* * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

* Download Fernald's TFP series 
* Source: https://www.frbsf.org/economic-research/indicators-data/total-factor-productivity-tfp/
* Download the Excel file "quarterly_tfp.xlsx" located at the bottom of the page. 
* The data is on the tab "annual"
* Accessed: September 2022
import excel "$datapath/quarterly_tfp.xlsx", sheet("annual") firstrow clear
keep date dtfp dtfp_util
ren date year 
drop if year == . 
save tmp1.dta, replace

* Download real GDP data from FRED
import fred GDPC1, aggregate(annual) clear
tsmktim year, start(1947)
drop date*
ren G GDPr
compress

merge 1:1 year using tmp1.dta, nogen
order year 
drop if year > 2021

save "$datapath/productivity_data.dta", replace

erase tmp1.dta

